<?php

namespace App\Http\Controllers;


use App\Helpers\StaticsData;
use App\Helpers\TransFormData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class IndexController extends Controller
{

    public function index()
    {
        return view('v1.index');
    }

    public function sendMail(Request $request)
    {
        
        $input = $request->all();

        $validator = Validator::make($input, [
            'name' => 'required|string',
            'email' => 'required|email',
            'message' => 'required|string',
        ]);

        $name = TransFormData::test_input($input['name']);
        $email = TransFormData::test_input($input['email']);
        $message = TransFormData::test_input($input['message']);
        
        if ($validator->fails()) {
            toastr()->error('Error in passed data!');
        }

        $subject = "Contact Message";

        $message = "<html dir='rtl'><head>
                <title>Contact Message</title>
                </head>
                <body style='direction:rtl'>
                <center>
                <h2 style='margin-top:50px;'>رسالة جديدة</h2>
                <table border='1' style='width:70%;'>
                <tr>
                <th style='color:red;'>الاسم</th>
                <th style='color:red;'>الايميل</th>
                <th style='color:red;'>الرسالة</th>
</th>
</tr>
<tr>
<td style='text-align: center;'>" . $name . "</td>
<td style='text-align: center;'>" . $email . "</td>
<td style='text-align: center;'>" . $message . "</td>
</td>
</tr>
</table>
                </center>
                </body></html>";

        // Always set content-type when sending HTML email
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";


        // More headers
        $headers .= 'From: <' . $email . '>' . "\r\n";

        // Mail it
        if (mail(StaticsData::$EMAIL, $subject, $message, $headers)) {
            toastr()->success('Your message sent ... thank you');
        } else {
            toastr()->error('Mail not sent! ... please try again later!');
        }

        return redirect()->back();
    }
}
